
#################################
# ellipse: Make an ellipse
#################################
#install.packages("ellipse",dep=T)
library(ellipse)

#Example 1: ellipse equation
#(x-mu)'A(x-mu)=c^2

A <- diag(c(1/4, 1))
c = 1
plot(ellipse(solve(A), centre = c(0, 0), t = c^2, level = 0.99), type = "l")
title("Ellipse plot")
text(0,0,expression(frac(x^2,4)+frac(y^2,1)==1),col=2,cex=2)
###############################################
## contoures of bivariate normal from samples
###############################################
### Example 2:
library(car)
x <- rnorm(1000)
y <- rnorm(1000)

dataEllipse(x, y, levels = c(0.5, 0.975))

layout(matrix(c(1,1,2,3), 2, 2, byrow = TRUE))
dataEllipse(x, y, levels = 0.1 * 1:9, ellipse.label = 0.1 * 1:9, lty = 2, fill = TRUE, 
	fill.alpha = 0.1, pch = 20, cex = 0.5)
title("Standard biNormal Distribution with samples")

# Simulate bivariate normal data
library(MASS)
mu <- c(0, 0) # Mean
rho=.9
Sigma <- matrix(c(1, rho, rho, 1), 2) # Covariance matrix
# Generate sample from N(mu, Sigma) with correlation rho
bivn <- mvrnorm(1000, mu = mu, Sigma = Sigma) # from Mass package
x<-bivn[,1]
y<-bivn[,2]
#par(mfrow=c(1,2),mar=c(4,4,2,2))
dataEllipse(x, y, levels = 0.1 * 1:9, ellipse.label = 0.1 * 1:9, lty = 2, fill = TRUE, 
	fill.alpha = 0.1, pch = 20, cex = 0.5)
title("Contoures of biNormal Distribution with samples with rho=0.9",cex.main = .6)

# rho=-0.8
rho=-0.8
Sigma <- matrix(c(1, rho, rho, 1), 2) # Covariance matrix
# Generate sample from N(mu, Sigma) with correlation rho
bivn <- mvrnorm(1000, mu = mu, Sigma = Sigma) # from Mass package
x<-bivn[,1]
y<-bivn[,2]
dataEllipse(x, y, levels = 0.1 * 1:9, ellipse.label = 0.1 * 1:9, lty = 2, fill = TRUE, 
	fill.alpha = 0.1, pch = 20, cex = 0.5)
title("Contoures of biNormal Distribution with samples with rho=-0.8",cex.main = .6)


##################
#Examples 3: biNormal Distribution
# Plot an ellipse corresponding to a 95% probability region for a
# bivariate normal distribution with mean 0, unit variances and 
# correlation 0.9,0.7,0.5,0.3,0
#positive correlations
layout(matrix(c(1,1,2,2), 2))
plot(ellipse::ellipse(0.9), type = "l", col = "gray70", xlim = c(-3, 4), ylim = c(-3, 4))
lines(ellipse::ellipse(0.7), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(0.5), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(0.3), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(0), type = "l", lty = 1, lwd = 1.5, col = 4)
legend("topright", legend = c("rho=0.9", "rho=0.7", "rho=0.5", "rho=0.3", "rho=0"), 
	lty = c(1, 2, 2, 2, 1), col = c("gray70", "gray70", "gray70", "gray70", 4), cex = 0.7,bty = "n")
#negative correlations -0.9,-0.7,-0.5,-0.3,0
plot(ellipse(-0.9), type = "l", col = "gray70",xlim = c(-3, 4), ylim = c(-3, 4))
lines(ellipse::ellipse(-0.7), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(-0.5), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(-0.3), type = "l", lty = 2, col = "gray70")
lines(ellipse::ellipse(0), type = "l", lty = 1, lwd = 1.5, col = 2)
legend("topright", legend = c("rho=-0.9", "rho=-0.7", "rho=-0.5", "rho=-0.3", "rho=0"), 
	lty = c(1, 2, 2, 2, 1), col = c("gray70", "gray70", "gray70", "gray70", 2), cex = 0.7,bty = "n")


################################################################
### Example 4:
# SIMULATING MULTIVARIATE DATA
library(MASS)
# Simulate bivariate normal data
mu <- c(0, 0) # Mean
mu
Sigma <- matrix(c(1, 0.5, 0.5, 1), 2) # Covariance matrix
Sigma
# Classic Bivariate Normal Diagram
# Generate sample from N(mu, Sigma)
bivn <- mvrnorm(2000, mu = mu, Sigma = Sigma) # from Mass package
#
library(ellipse)
rho <- cor(bivn)
y_on_x <- lm(bivn[, 2] ~ bivn[, 1]) # Regressiion Y ~ X
x_on_y <- lm(bivn[, 1] ~ bivn[, 2]) # Regression X ~ Y
layout(matrix(c(1,1,1,1), 2))
plot_legend <- c("99% CI green", "95% CI red", "90% CI blue", "Y on X black", "X on Y brown")
plot(bivn, xlab = "X", ylab = "Y", col = "dark blue", main = "Bivariate Normal with Confidence Intervals",pch=20,cex=.5,ylim=c(-3,4),xlim=c(-3,4))
lines(ellipse::ellipse(rho), col = "red") # ellipse() from ellipse package
lines(ellipse::ellipse(rho, level = 0.99), col = "green")
lines(ellipse::ellipse(rho, level = 0.9), col = "blue")
abline(y_on_x)
abline(x_on_y, col = "brown")
legend(3, 1, legend = plot_legend, cex = 0.5, bty = "n")


